; Compiled with: PIC Simulator IDE v6.91
; Microcontroller model: PIC12F675
; Clock frequency: 4.0 MHz
;
;       The address of 'mydata' (byte) (encode) is 0x2D
;       The address of 'tmp' (word) (global) is 0x2E
	tmp EQU 0x2E
;       The address of 'tpacket' (array 5) (byte) (global) is 0x30
	tpacket EQU 0x30
;       The address of 'crc' (byte) (global) is 0x35
	crc EQU 0x35
;       The address of 'packet' (byte) (global) is 0x36
	packet EQU 0x36
;       The address of 'x1' (byte) (global) is 0x37
	x1 EQU 0x37
;       The address of 'temp1' (byte) (global) is 0x38
	temp1 EQU 0x38
;       The address of 'temp2' (byte) (global) is 0x39
	temp2 EQU 0x39
;       The address of 'temp3' (byte) (global) is 0x3A
	temp3 EQU 0x3A
;       The address of 'humidity1' (byte) (global) is 0x3B
	humidity1 EQU 0x3B
;       The address of 'humidity2' (byte) (global) is 0x3C
	humidity2 EQU 0x3C
;       The address of 'tempsign' (byte) (global) is 0x3D
	tempsign EQU 0x3D
;       The address of 'hum' (word) (global) is 0x3E
	hum EQU 0x3E
;       The address of 'sleeptimer' (byte) (global) is 0x40
	sleeptimer EQU 0x40
;       The address of 'battflag' (byte) (global) is 0x41
	battflag EQU 0x41
;       The address of 'n' (byte) (global) is 0x42
	n EQU 0x42
;       The address of 'x2' (byte) (global) is 0x43
	x2 EQU 0x43
;       The address of 'channel' (byte) (global) is 0x44
	channel EQU 0x44
;       The address of 'rollingcode1' (byte) (global) is 0x45
	rollingcode1 EQU 0x45
;       The address of 'rollingcode2' (byte) (global) is 0x46
	rollingcode2 EQU 0x46
;       The address of 'humidity3' (byte) (global) is 0x47
	humidity3 EQU 0x47
;       The address of 'sensorid1' (byte) (global) is 0x48
	sensorid1 EQU 0x48
;       The address of 'sensorid2' (byte) (global) is 0x49
	sensorid2 EQU 0x49
;       The address of 'sensorid3' (byte) (global) is 0x4A
	sensorid3 EQU 0x4A
;       The address of 'sensorid4' (byte) (global) is 0x4B
	sensorid4 EQU 0x4B
;       The address of 'unknown' (byte) (global) is 0x4C
	unknown EQU 0x4C
;       The address of 'packetbit' (byte) (global) is 0x4D
	packetbit EQU 0x4D
;       The address of 'chksm' (byte) (global) is 0x4E
	chksm EQU 0x4E
;       The address of 'flags' (byte) (global) is 0x4F
	flags EQU 0x4F
;       The address of 'syncflag' (byte) (global) is 0x50
	syncflag EQU 0x50
;       The address of 'crc1' (byte) (global) is 0x51
	crc1 EQU 0x51
;       The address of 'crc2' (byte) (global) is 0x52
	crc2 EQU 0x52
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	ARRARG_0 EQU 0x2C
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0011
	ORG 0x0004
	RETFIE
; Begin of program
L0011:
; 1: 'This code simulates an Oregon Scientific temperature sensor, type THGR810
; 2: 'This sensor measures temperature and humidity and trasnmits the data to an Arduino Weather Shield  using
; 3: '433.92 Mhz
; 4: 'The data is sent in 4 bit nibbles using normal Manchester coding.
; 5: 'The data rate is 1024 Hz which equals Oregon V3 protocol. 1/2 bit time = 488 uS
; 6: 'The RF message data layout is as follows.
; 7: 'A preamble of 6 nibbles consisting of all 1.
; 8: 'A sync nibble of 10.
; 9: 'Sensor data follows.
; 10: 
; 11: 
; 12: 'Sensor data is as follows.
; 13: 'Sensor ID - 4 nibbles, oregon THGR810 has ID of F824
; 14: 'Sensor rolling code  - 1 nibble
; 15: 'Sensor battery flag  - 1 nibble
; 16: 'Sensor temperature  - 3 nibbles format is xx.x deg
; 17: 'Sensor temperature sign - 1 nibble 0 is positive , non zero is negative.
; 18: 'Sensor humidity - 2 nibbles = xx%
; 19: '1 nibble next of which purpose is unknown.****
; 20: 'Sensor CRC which is simply arithmetical sum of data from Sensor data to above data ****
; 21: 'Sensor post amble - 2 nibbles purpose unknown.
; 22: 'Nibbles are sent in order with the LSB of each nibble sent first.
; 23: 'Sensor code for THGR810 sensor is F824.
; 24: 'IMPORTANT - the Oregon Wireless Protocol is not 100% understood.
; 25: 'Whilst the code works for the Arduino Weather Shield , it doesnt work yet for a genuine Oregon Weather Station Console
; 26: 'Im still trying to figure out whats missing.
; 27: 
; 28: 
; 29: 
; 30: 
; 31: 'Notes on the DHT22 temp Sensor.
; 32: 'This Sensor sends 5 bytes of data which are RH1-RH2, Temp1-Temp2, crc
; 33: 'Rh1-Rh2 is a 16 bit word that is divided by 10 to read XX.X %
; 34: 'Temp1-Temp2 is a 16 bit word that is divided by 10 to read XX.X D
; 35: 'If the MSB of Temp1 is 1 , the temp is -, ie below 0D C.
; 36: 'The CRC is the 8 bit sum the 4 data bytes.
; 37: 'The program decodes the DHT22 by measuring the time length of the data pulses and uses timer 0.
; 38: 'The clock oscillator in the chip needs to run at 4Mhz.
; 39: 'Current version 17/09/2012
; 40: 
; 41: 
; 42: 
; 43: AllDigital
	BSF STATUS,RP0
	CLRF 0x1F
	MOVLW 0x07
	BCF STATUS,RP0
	MOVWF 0x19
; 44: Define CLOCK_FREQUENCY = 4
; 45: OSCCAL = 50  'Try and get the internal osc as close to 4 Mhz as possible.
	MOVLW 0x32
	BSF STATUS,RP0
	MOVWF 0x10
; 46: 
; 47: 
; 48: 
; 49: Dim x1 As Byte
; 50: Dim x2 As Byte
; 51: Dim flags As Byte
; 52: Dim syncflag As Byte
; 53: Dim channel As Byte
; 54: Dim rollingcode1 As Byte
; 55: Dim rollingcode2 As Byte
; 56: Dim battflag As Byte
; 57: Dim temp1 As Byte
; 58: Dim temp2 As Byte
; 59: Dim temp3 As Byte
; 60: Dim tempsign As Byte
; 61: Dim humidity1 As Byte
; 62: Dim humidity2 As Byte
; 63: Dim humidity3 As Byte
; 64: Dim sensorid1 As Byte
; 65: Dim sensorid2 As Byte
; 66: Dim sensorid3 As Byte
; 67: Dim sensorid4 As Byte
; 68: Dim unknown As Byte
; 69: Dim crc As Byte
; 70: Dim crc1 As Byte
; 71: Dim crc2 As Byte
; 72: Dim hum As Word
; 73: Dim tmp As Word
; 74: Dim sleeptimer As Byte
; 75: 
; 76: 
; 77: 
; 78: 
; 79: Dim packet As Byte
; 80: Dim tpacket(5) As Byte
; 81: Dim packetbit As Byte
; 82: Dim n As Byte
; 83: Dim chksm As Byte
; 84: TRISIO.2 = 0  'Set ports to OP
	BCF 0x05,2
; 85: TRISIO.4 = 0
	BCF 0x05,4
; 86: TRISIO.5 = 0
	BCF 0x05,5
	BCF STATUS,RP0
; 87: flags = 15
	MOVLW 0x0F
	MOVWF 0x4F
; 88: syncflag = 10
	MOVLW 0x0A
	MOVWF 0x50
; 89: sensorid1 = 0xf  'nibble 0  'F824 is the ID code of a THGR810 Sensor
	MOVLW 0x0F
	MOVWF 0x48
; 90: sensorid2 = 0x8  'nibble 1
	MOVLW 0x08
	MOVWF 0x49
; 91: sensorid3 = 0x2  'nibble 2
	MOVLW 0x02
	MOVWF 0x4A
; 92: sensorid4 = 0x4  'nibble 3
	MOVLW 0x04
	MOVWF 0x4B
; 93: channel = 5  'nibble 4 (THGR810 can use channels 1 to 10, but 1 is normally reserved by outside temp sensor.)
	MOVLW 0x05
	MOVWF 0x44
; 94: rollingcode1 = 0x8  'nibble 5, this number can be any number between 1 - 255
	MOVLW 0x08
	MOVWF 0x45
; 95: rollingcode2 = 0x4  'nibble 6
	MOVLW 0x04
	MOVWF 0x46
; 96: 
; 97: battflag = 0  'nibble 7 'this flag = low battery in the sensor
	CLRF 0x41
; 98: temp1 = 4  'nibble 8 'Temp=21.4
	MOVLW 0x04
	MOVWF 0x38
; 99: temp2 = 1  'nibble 9
	MOVLW 0x01
	MOVWF 0x39
; 100: temp3 = 2  'nibble 10
	MOVLW 0x02
	MOVWF 0x3A
; 101: tempsign = 0  'nibble 11 0 for positive value, non zero for negative value
	CLRF 0x3D
; 102: humidity1 = 2  'nibble 12 28%
	MOVLW 0x02
	MOVWF 0x3B
; 103: humidity2 = 8  'nibble 13
	MOVLW 0x08
	MOVWF 0x3C
; 104: humidity3 = 0  'Not used in this version.
	CLRF 0x47
; 105: unknown = 0  'nibble 14 not known what this data is for.
	CLRF 0x4C
; 106: 
; 107: sleeptimer = 0  'used to set sleep times , time is sleeptimer X 3
	CLRF 0x40
; 108: 
; 109: 
; 110: OPTION_REG.T0CS = 0  'enable tmr0
	BSF STATUS,RP0
	BCF 0x01,5
; 111: OPTION_REG.PSA = 1  'Prescaler assigned to the WDT
	BSF 0x01,3
; 112: OPTION_REG.PS2 = 1  'Prescaler set to 128, approx 3 seconds b4 WDT wakes up.
	BSF 0x01,2
; 113: OPTION_REG.PS1 = 1
	BSF 0x01,1
; 114: OPTION_REG.PS0 = 1
	BSF 0x01,0
	BCF STATUS,RP0
; 115: 
; 116: For x1 = 1 To 10  'Flash the led to indicate we have started.
	MOVLW 0x01
	MOVWF 0x37
L0012:
	MOVF 0x37,W
	SUBLW 0x0A
	BTFSS STATUS,C
	GOTO L0013
; 117: GPIO.4 = 1
	BSF 0x05,4
; 118: WaitMs 500
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
	CALL W001
; 119: GPIO.4 = 0
	BCF 0x05,4
; 120: WaitMs 500
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
	CALL W001
; 121: ASM:        clrwdt  'The WDT fires every 2 seconds, so need to clear it slightly less than 2 secs .
	clrwdt
; 122: Next x1
	MOVLW 0x01
	ADDWF 0x37,F
	BTFSS STATUS,C
	GOTO L0012
L0013:
; 123: 
; 124: start:
L0001:
; 125: sleepagain:
L0002:
; 126: ASM:        sleep  'this puts the CPU in low power mode for 2.3 seconds
	sleep
; 127: sleeptimer = sleeptimer + 1
	MOVF 0x40,W
	ADDLW 0x01
	MOVWF 0x40
; 128: If sleeptimer < 12 Then Goto sleepagain
	MOVLW 0x0C
	SUBWF 0x40,W
	BTFSC STATUS,C
	GOTO L0014
	GOTO L0002
L0014:
; 129: sleeptimer = 0
	CLRF 0x40
; 130: 
; 131: 
; 132: TRISIO.2 = 0  'portb o/p
	BSF STATUS,RP0
	BCF 0x05,2
	BCF STATUS,RP0
; 133: GPIO.2 = 1  'make high
	BSF 0x05,2
; 134: WaitMs 50  'wait
	MOVLW 0x32
	MOVWF R0L
	CLRF R0H
	CALL W001
; 135: GPIO.2 = 0
	BCF 0x05,2
; 136: WaitMs 20  'send 20ms low,,wait for DHT22 to respond
	MOVLW 0x14
	MOVWF R0L
	CLRF R0H
	CALL W001
; 137: TRISIO.2 = 1  'portb i/p
	BSF STATUS,RP0
	BSF 0x05,2
	BCF STATUS,RP0
; 138: p1: If GPIO.2 = 1 Then Goto p1  'skip next 3 pulses so we get to the first bit pulse.
L0003:
	BTFSS 0x05,2
	GOTO L0015
	GOTO L0003
L0015:
; 139: p2: If GPIO.2 = 0 Then Goto p2
L0004:
	BTFSC 0x05,2
	GOTO L0016
	GOTO L0004
L0016:
; 140: p3: If GPIO.2 = 1 Then Goto p3
L0005:
	BTFSS 0x05,2
	GOTO L0017
	GOTO L0005
L0017:
; 141: 
; 142: For n = 0 To 4  '5 bytes to receive
	CLRF 0x42
L0018:
	MOVF 0x42,W
	SUBLW 0x04
	BTFSS STATUS,C
	GOTO L0019
; 143: packet = 0
	CLRF 0x36
; 144: 
; 145: For packetbit = 1 To 8  '8 bits per data packet
	MOVLW 0x01
	MOVWF 0x4D
L0020:
	MOVF 0x4D,W
	SUBLW 0x08
	BTFSS STATUS,C
	GOTO L0021
; 146: packet = ShiftLeft(packet, 1)  'accumulate bits To make data Byte
	MOVF 0x36,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x01
	CALL SL00
	MOVF R0L,W
	MOVWF 0x36
; 147: 
; 148: loop: If GPIO.2 = 0 Then Goto loop  'Wait for high which is start of data bit.
L0006:
	BTFSC 0x05,2
	GOTO L0022
	GOTO L0006
L0022:
; 149: TMR0 = 0  'clear timer0
	CLRF 0x01
; 150: loop1: If GPIO.2 = 1 Then Goto loop1  'Wait for low which = end of data bit
L0007:
	BTFSS 0x05,2
	GOTO L0023
	GOTO L0007
L0023:
; 151: If TMR0 > 50 Then  'Data 1 = pulse of 70 uS, data 0 = pulse of 28 uS.
	MOVF 0x01,W
	SUBLW 0x32
	BTFSC STATUS,C
	GOTO L0024
; 152: 	High packet.0  'Set bit 0 of packet to 1
	BSF 0x36,0
; 153: Else
	GOTO L0025
L0024:
; 154: 	Low packet.0  'set bit 0 of packet to 0
	BCF 0x36,0
; 155: Endif
L0025:
; 156: Next packetbit
	MOVLW 0x01
	ADDWF 0x4D,F
	BTFSS STATUS,C
	GOTO L0020
L0021:
; 157: tpacket(n) = packet
	MOVF 0x42,W
	ADDLW 0x30
	MOVWF FSR
	MOVF 0x36,W
	MOVWF INDF
; 158: Next n
	MOVLW 0x01
	ADDWF 0x42,F
	BTFSS STATUS,C
	GOTO L0018
L0019:
; 159: chksm = (tpacket(0) + tpacket(1) + tpacket(2) + tpacket(3))
;       The address of 'oshonsoft_temp_1' (word) (global) is 0x53
	oshonsoft_temp_1 EQU 0x53
	MOVF 0x30,W
	ADDWF 0x31,W
	MOVWF 0x53
	CLRW
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x54
	MOVF 0x53,W
	ADDWF 0x32,W
	MOVWF 0x53
	MOVF 0x54,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x54
	MOVF 0x53,W
	ADDWF 0x33,W
	MOVWF 0x53
	MOVF 0x54,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x54
	MOVF 0x53,W
	MOVWF 0x4E
; 160: If tpacket(4) <> chksm Then Goto error  'last 8 bits of packet are checksum
	MOVF 0x34,W
	SUBWF 0x4E,W
	BTFSC STATUS,Z
	GOTO L0026
	GOTO L0008
L0026:
; 161: hum.HB = tpacket(0)
	MOVF 0x30,W
	MOVWF 0x3F
; 162: hum.LB = tpacket(1)
	MOVF 0x31,W
	MOVWF 0x3E
; 163: tmp.HB = tpacket(2)
	MOVF 0x32,W
	MOVWF 0x2F
; 164: tmp.LB = tpacket(3)
	MOVF 0x33,W
	MOVWF 0x2E
; 165: 
; 166: If tmp.15 = 1 Then  'used to indicate negative temp
	BTFSS 0x2F,7
	GOTO L0027
; 167: 	tmp.15 = 0
	BCF 0x2F,7
; 168: 	tempsign = 1
	MOVLW 0x01
	MOVWF 0x3D
; 169: Else
	GOTO L0028
L0027:
; 170: 	tempsign = 0
	CLRF 0x3D
; 171: Endif
L0028:
; 172: 
; 173: 
; 174: temp3 = tmp / 100
	MOVF 0x2E,W
	MOVWF R0L
	MOVF 0x2F,W
	MOVWF R0H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x53
	MOVF R0H,W
	MOVWF 0x54
	MOVF 0x53,W
	MOVWF 0x3A
; 175: temp2 = (tmp Mod 100) / 10
	MOVF 0x2E,W
	MOVWF R0L
	MOVF 0x2F,W
	MOVWF R0H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R2L,W
	MOVWF 0x53
	MOVF R2H,W
	MOVWF 0x54
	MOVF 0x53,W
	MOVWF R0L
	MOVF 0x54,W
	MOVWF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x53
	MOVF R0H,W
	MOVWF 0x54
	MOVF 0x53,W
	MOVWF 0x39
; 176: temp1 = (tmp Mod 100) Mod 10
	MOVF 0x2E,W
	MOVWF R0L
	MOVF 0x2F,W
	MOVWF R0H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R2L,W
	MOVWF 0x53
	MOVF R2H,W
	MOVWF 0x54
	MOVF 0x53,W
	MOVWF R0L
	MOVF 0x54,W
	MOVWF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R2L,W
	MOVWF 0x53
	MOVF R2H,W
	MOVWF 0x54
	MOVF 0x53,W
	MOVWF 0x38
; 177: humidity2 = hum / 100
	MOVF 0x3E,W
	MOVWF R0L
	MOVF 0x3F,W
	MOVWF R0H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x53
	MOVF R0H,W
	MOVWF 0x54
	MOVF 0x53,W
	MOVWF 0x3C
; 178: humidity1 = (hum Mod 100) / 10
	MOVF 0x3E,W
	MOVWF R0L
	MOVF 0x3F,W
	MOVWF R0H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R2L,W
	MOVWF 0x53
	MOVF R2H,W
	MOVWF 0x54
	MOVF 0x53,W
	MOVWF R0L
	MOVF 0x54,W
	MOVWF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R0L,W
	MOVWF 0x53
	MOVF R0H,W
	MOVWF 0x54
	MOVF 0x53,W
	MOVWF 0x3B
; 179: humidity3 = (hum Mod 100) Mod 10
	MOVF 0x3E,W
	MOVWF R0L
	MOVF 0x3F,W
	MOVWF R0H
	MOVLW 0x64
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R2L,W
	MOVWF 0x53
	MOVF R2H,W
	MOVWF 0x54
	MOVF 0x53,W
	MOVWF R0L
	MOVF 0x54,W
	MOVWF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
	CALL D001
	MOVF R2L,W
	MOVWF 0x53
	MOVF R2H,W
	MOVWF 0x54
	MOVF 0x53,W
	MOVWF 0x47
; 180: 
; 181: ASM:        clrwdt
	clrwdt
; 182: WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	CALL W001
; 183: Goto transmit
	GOTO L0009
; 184: 
; 185: error:
L0008:
; 186: 'we should never get here but if we do its most likely that the battery is going flat.
; 187: battflag = 0xc  'set the battery flat flag.
	MOVLW 0x0C
	MOVWF 0x41
; 188: temp1 = 0
	CLRF 0x38
; 189: temp2 = 0
	CLRF 0x39
; 190: temp3 = 0  'set all variables To 0
	CLRF 0x3A
; 191: humidity1 = 0
	CLRF 0x3B
; 192: humidity2 = 0
	CLRF 0x3C
; 193: 
; 194: 
; 195: transmit:
L0009:
; 196: 'Transmitting Code
; 197: 'Calculate the CRC
; 198: 
; 199: crc = sensorid1 + sensorid2 + sensorid3 + sensorid4 + channel + rollingcode1 + rollingcode2 + battflag + temp1 + temp2 + temp3
	MOVF 0x48,W
	ADDWF 0x49,W
	MOVWF 0x53
	CLRW
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x54
	MOVF 0x53,W
	ADDWF 0x4A,W
	MOVWF 0x53
	MOVF 0x54,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x54
	MOVF 0x53,W
	ADDWF 0x4B,W
	MOVWF 0x53
	MOVF 0x54,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x54
	MOVF 0x53,W
	ADDWF 0x44,W
	MOVWF 0x53
	MOVF 0x54,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x54
	MOVF 0x53,W
	ADDWF 0x45,W
	MOVWF 0x53
	MOVF 0x54,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x54
	MOVF 0x53,W
	ADDWF 0x46,W
	MOVWF 0x53
	MOVF 0x54,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x54
	MOVF 0x53,W
	ADDWF 0x41,W
	MOVWF 0x53
	MOVF 0x54,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x54
	MOVF 0x53,W
	ADDWF 0x38,W
	MOVWF 0x53
	MOVF 0x54,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x54
	MOVF 0x53,W
	ADDWF 0x39,W
	MOVWF 0x53
	MOVF 0x54,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x54
	MOVF 0x53,W
	ADDWF 0x3A,W
	MOVWF 0x53
	MOVF 0x54,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x54
	MOVF 0x53,W
	MOVWF 0x35
; 200: crc = crc + tempsign + humidity1 + humidity2 + unknown
	MOVF 0x35,W
	ADDWF 0x3D,W
	MOVWF 0x53
	CLRW
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x54
	MOVF 0x53,W
	ADDWF 0x3B,W
	MOVWF 0x53
	MOVF 0x54,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x54
	MOVF 0x53,W
	ADDWF 0x3C,W
	MOVWF 0x53
	MOVF 0x54,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x54
	MOVF 0x53,W
	ADDWF 0x4C,W
	MOVWF 0x53
	MOVF 0x54,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x54
	MOVF 0x53,W
	MOVWF 0x35
; 201: crc1 = crc And 0xf
	MOVF 0x35,W
	MOVWF R0L
	MOVLW 0x0F
	ANDWF R0L,W
	MOVWF 0x51
; 202: crc2 = ShiftRight(crc, 4)
	MOVF 0x35,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x04
	CALL SR00
	MOVF R0L,W
	MOVWF 0x52
; 203: 'The above values are taken from the document Oregon Scientific RF protocol description June 2011.
; 204: 
; 205: 
; 206: 
; 207: 'We start transmitting here.
; 208: GPIO.4 = 1  'Turn on Led
	BSF 0x05,4
; 209: WaitMs 50
	MOVLW 0x32
	MOVWF R0L
	CLRF R0H
	CALL W001
; 210: GPIO.5 = 1  'turn on tx
	BSF 0x05,5
; 211: WaitUs 1000
	MOVLW 0xE8
	MOVWF R4L
	MOVLW 0x03
	MOVWF R4H
	CALL Y001
; 212: GPIO.5 = 0
	BCF 0x05,5
; 213: WaitUs 628
	MOVLW 0x74
	MOVWF R4L
	MOVLW 0x02
	MOVWF R4H
	CALL Y001
; 214: 
; 215: For x1 = 1 To 6  'Transmit flags
	MOVLW 0x01
	MOVWF 0x37
L0029:
	MOVF 0x37,W
	SUBLW 0x06
	BTFSS STATUS,C
	GOTO L0030
; 216: 
; 217: Call encode(flags)
	MOVF 0x4F,W
	MOVWF 0x2D
	CALL L0010
; 218: Next x1
	MOVLW 0x01
	ADDWF 0x37,F
	BTFSS STATUS,C
	GOTO L0029
L0030:
; 219: 
; 220: Call encode(syncflag)  'Transmit sync
	MOVF 0x50,W
	MOVWF 0x2D
	CALL L0010
; 221: 
; 222: Call encode(sensorid1)  'Transmit Sensor ID
	MOVF 0x48,W
	MOVWF 0x2D
	CALL L0010
; 223: Call encode(sensorid2)
	MOVF 0x49,W
	MOVWF 0x2D
	CALL L0010
; 224: Call encode(sensorid3)
	MOVF 0x4A,W
	MOVWF 0x2D
	CALL L0010
; 225: Call encode(sensorid4)
	MOVF 0x4B,W
	MOVWF 0x2D
	CALL L0010
; 226: 
; 227: Call encode(channel)  'Sensor Channel
	MOVF 0x44,W
	MOVWF 0x2D
	CALL L0010
; 228: 
; 229: Call encode(rollingcode1)  'sensor rolling code
	MOVF 0x45,W
	MOVWF 0x2D
	CALL L0010
; 230: Call encode(rollingcode2)
	MOVF 0x46,W
	MOVWF 0x2D
	CALL L0010
; 231: 
; 232: Call encode(battflag)  'Battery flag
	MOVF 0x41,W
	MOVWF 0x2D
	CALL L0010
; 233: 
; 234: Call encode(temp1)  'Send temperature LSB first
	MOVF 0x38,W
	MOVWF 0x2D
	CALL L0010
; 235: Call encode(temp2)
	MOVF 0x39,W
	MOVWF 0x2D
	CALL L0010
; 236: Call encode(temp3)
	MOVF 0x3A,W
	MOVWF 0x2D
	CALL L0010
; 237: Call encode(tempsign)  'Indicates a positive temp
	MOVF 0x3D,W
	MOVWF 0x2D
	CALL L0010
; 238: 
; 239: Call encode(humidity1)  'send humidity. LSB first
	MOVF 0x3B,W
	MOVWF 0x2D
	CALL L0010
; 240: Call encode(humidity2)
	MOVF 0x3C,W
	MOVWF 0x2D
	CALL L0010
; 241: Call encode(unknown)
	MOVF 0x4C,W
	MOVWF 0x2D
	CALL L0010
; 242: Call encode(crc1)  'Send CRC checksum LSB first.
	MOVF 0x51,W
	MOVWF 0x2D
	CALL L0010
; 243: Call encode(crc2)
	MOVF 0x52,W
	MOVWF 0x2D
	CALL L0010
; 244: WaitMs 1
	MOVLW 0x01
	MOVWF R0L
	CLRF R0H
	CALL W001
; 245: GPIO.5 = 0
	BCF 0x05,5
; 246: GPIO.4 = 0  'turn off led
	BCF 0x05,4
; 247: 
; 248: Goto start
	GOTO L0001
; 249: 
; 250: 
; 251: 
; 252: 
; 253: 
; 254: 
; 255: End
L0031:	GOTO L0031
; 256: 
; 257: 
; 258: 'This routine encodes a 4 bit nibble into Manchester format.
; 259: Proc encode(mydata As Byte)
L0010:
; 260: 
; 261: For x2 = 0 To 3
	CLRF 0x43
L0032:
	MOVF 0x43,W
	SUBLW 0x03
	BTFSS STATUS,C
	GOTO L0033
; 262: 	
; 263: If mydata.0 = 1 Then
	BTFSS 0x2D,0
	GOTO L0034
; 264: 	GPIO.5 = 1
	BSF 0x05,5
; 265: 	WaitUs 488
	MOVLW 0xE8
	MOVWF R4L
	MOVLW 0x01
	MOVWF R4H
	CALL Y001
; 266: 	GPIO.5 = 0
	BCF 0x05,5
; 267: 	WaitUs 488
	MOVLW 0xE8
	MOVWF R4L
	MOVLW 0x01
	MOVWF R4H
	CALL Y001
; 268: Else
	GOTO L0035
L0034:
; 269: 	GPIO.5 = 0
	BCF 0x05,5
; 270: 	WaitUs 488
	MOVLW 0xE8
	MOVWF R4L
	MOVLW 0x01
	MOVWF R4H
	CALL Y001
; 271: 	GPIO.5 = 1
	BSF 0x05,5
; 272: 	WaitUs 488
	MOVLW 0xE8
	MOVWF R4L
	MOVLW 0x01
	MOVWF R4H
	CALL Y001
; 273: Endif
L0035:
; 274: mydata = ShiftRight(mydata, 1)
	MOVF 0x2D,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x01
	CALL SR00
	MOVF R0L,W
	MOVWF 0x2D
; 275: Next x2
	MOVLW 0x01
	ADDWF 0x43,F
	BTFSS STATUS,C
	GOTO L0032
L0033:
; 276: End Proc
	RETURN
; 277: 
; 278: 
; 279: 
; 280: 
; 281: 
; 282: 
; 283: 
; 284: 
; 285: 
; 286: 
; 287: 
; End of program
L0036:	GOTO L0036
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:
	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x12
	MOVWF R1L
W005:
	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:
	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:
	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Waitus Routine Word
Y001:	MOVLW 0x10
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
Y002:	MOVLW 0x0A
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
; Word ShiftLeft Routine
SL01:	BCF STATUS,C
	RLF R0L,F
	RLF R0H,F
SL00:	ADDLW 0xFF
	BTFSC STATUS,C
	GOTO SL01
	RETURN
; Word ShiftRight Routine
SR01:	BCF STATUS,C
	RRF R0H,F
	RRF R0L,F
SR00:	ADDLW 0xFF
	BTFSC STATUS,C
	GOTO SR01
	RETURN
; End of listing
	END
